#ifndef __AUTO_DISCOVERY_H__
#define __AUTO_DISCOVERY_H__

#include "autodiscenv.h"                // environment-specific includes
#include "dm_autodiscovery.h"           // interface specific includes

////////////////////////////////////////////////////////////////////////////////

// message types
#define CIP_AUTODISCOVERY_QUERY         0x14
#define CIP_AUTODISCOVERY_RESPONSE      0x15
#define CIP_HOSTNAME_QUERY              0x16
#define CIP_HOSTNAME_RESPONSE           0x17
#define CIP_HOSTNAME_SET                0x18
#define CIP_HOSTNAME_ACK                0x19

// flags and bitmasks
#define CIP_AUTODIS_QUERY_RESPOND_FLAG              0x0001
#define CIP_AUTODIS_QUERY_SEND_IP_TABLE_FLAG        0x0002
#define CIP_AUTODIS_QUERY_CLEAR_IP_TABLE_FLAG       0x0004
#define CIP_AUTODIS_QUERY_SET_IP_ENTRY              0x0008
#define CIP_AUTODIS_QUERY_START_LIGHT_N_POLL        0x0010
#define CIP_AUTODIS_QUERY_STOP_LIGHT_N_POLL         0x0020
#define CIP_AUTODIS_QUERY_QUERY_SEND_IF_IP_TABLE_CLEAR  0x0040

#define CIP_AUTODIS_RESPONSE_MATCH_FOUND            0x0001
#define CIP_AUTODIS_RESPONSE_CONFIGURATION_REQUEST  0x0002
#define CIP_AUTODIS_RESPONSE_CONFIGURATION_BLOCKED  0x0004
#define CIP_AUTODIS_RESPONSE_LIGHT_N_POLL_STARTED   0x0008
#define CIP_AUTODIS_RESPONSE_LIGHT_N_POLL_STOPPED   0x0010
#define CIP_AUTODIS_RESPONSE_SETUP_BUTTON_PRESSED   0x0020
#define CIP_AUTODIS_RESPONSE_CONFIGURATION_SET      0x0040
#define CIP_AUTODIS_RESPONSE_TABLE_CLEARED          0x0080

#define CIP_AUTODIS_HOSTNAME_QUERY_ASSIGN           0x0001

#endif

